/*
 * Decompiled with CFR 0.152.
 */
package tool;

import java.awt.image.BufferedImage;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.PrintRequestAttributeSet;
import tool.ImagePrintable;

public class PrintUtil {
    private PrintService printService;
    private boolean hasUI = false;

    public void printImage(String filepath) throws IOException, PrinterException {
        BufferedImage image = ImageIO.read(new File(filepath));
        this.printImage(image);
    }

    public void printImage(BufferedImage image) throws PrinterException {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        if (this.printService != null) {
            printJob.setPrintService(this.printService);
        }
        printJob.setPrintable(new ImagePrintable(printJob, image));
        if (this.hasUI) {
            if (printJob.printDialog()) {
                printJob.print();
            }
        } else {
            printJob.print();
        }
    }

    public PrintService findPrintServicesName(String printname) {
        PrintService printservice = null;
        PrintService[] services = this.findPrintServices(null, null);
        if (services.length == 0) {
            return null;
        }
        for (int i = 0; i < services.length; ++i) {
            PrintService ps = services[i];
            if (!printname.equalsIgnoreCase(ps.getName())) continue;
            printservice = ps;
        }
        return printservice;
    }

    public PrintService[] findPrintServices(DocFlavor docflavor, PrintRequestAttributeSet pras) {
        PrintService[] services = PrintServiceLookup.lookupPrintServices(docflavor, pras);
        return services;
    }

    public PrintService getPrintService() {
        return this.printService;
    }

    public void setPrintService(PrintService printService) {
        this.printService = printService;
    }

    public boolean isHasUI() {
        return this.hasUI;
    }

    public void setHasUI(boolean hasUI) {
        this.hasUI = hasUI;
    }
}

