/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import junit.framework.TestCase;
import org.apache.commons.io.input.NullReader;

public class NullReaderTest
extends TestCase {
    public NullReaderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRead() throws Exception {
        int size = 5;
        TestNullReader reader = new TestNullReader(size);
        for (int i = 0; i < size; ++i) {
            NullReaderTest.assertEquals((String)("Check Value [" + i + "]"), (int)i, (int)reader.read());
        }
        NullReaderTest.assertEquals((String)"End of File", (int)-1, (int)reader.read());
        try {
            int result = reader.read();
            NullReaderTest.fail((String)("Should have thrown an IOException, value=[" + result + "]"));
        }
        catch (IOException e) {
            NullReaderTest.assertEquals((String)"Read after end of file", (String)e.getMessage());
        }
        reader.close();
        NullReaderTest.assertEquals((String)"Available after close", (long)0L, (long)reader.getPosition());
    }

    public void testReadCharArray() throws Exception {
        char[] chars = new char[10];
        TestNullReader reader = new TestNullReader(15);
        int count1 = ((Reader)((Object)reader)).read(chars);
        NullReaderTest.assertEquals((String)"Read 1", (int)chars.length, (int)count1);
        for (int i = 0; i < count1; ++i) {
            NullReaderTest.assertEquals((String)"Check Chars 1", (int)i, (int)chars[i]);
        }
        int count2 = ((Reader)((Object)reader)).read(chars);
        NullReaderTest.assertEquals((String)"Read 2", (int)5, (int)count2);
        for (int i = 0; i < count2; ++i) {
            NullReaderTest.assertEquals((String)"Check Chars 2", (int)(count1 + i), (int)chars[i]);
        }
        int count3 = ((Reader)((Object)reader)).read(chars);
        NullReaderTest.assertEquals((String)"Read 3 (EOF)", (int)-1, (int)count3);
        try {
            int count4 = ((Reader)((Object)reader)).read(chars);
            NullReaderTest.fail((String)("Should have thrown an IOException, value=[" + count4 + "]"));
        }
        catch (IOException e) {
            NullReaderTest.assertEquals((String)"Read after end of file", (String)e.getMessage());
        }
        ((Reader)((Object)reader)).close();
        int offset = 2;
        int lth = 4;
        int count5 = ((Reader)((Object)reader)).read(chars, offset, lth);
        NullReaderTest.assertEquals((String)"Read 5", (int)lth, (int)count5);
        for (int i = offset; i < lth; ++i) {
            NullReaderTest.assertEquals((String)"Check Chars 3", (int)i, (int)chars[i]);
        }
    }

    public void testEOFException() throws Exception {
        TestNullReader reader = new TestNullReader(2, false, true);
        NullReaderTest.assertEquals((String)"Read 1", (int)0, (int)((Reader)((Object)reader)).read());
        NullReaderTest.assertEquals((String)"Read 2", (int)1, (int)((Reader)((Object)reader)).read());
        try {
            int result = ((Reader)((Object)reader)).read();
            NullReaderTest.fail((String)("Should have thrown an EOFException, value=[" + result + "]"));
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void testMarkAndReset() throws Exception {
        int i;
        int position = 0;
        int readlimit = 10;
        TestNullReader reader = new TestNullReader(100, true, false);
        NullReaderTest.assertTrue((String)"Mark Should be Supported", (boolean)((Reader)((Object)reader)).markSupported());
        try {
            ((Reader)((Object)reader)).reset();
            NullReaderTest.fail((String)"Read limit exceeded, expected IOException ");
        }
        catch (IOException e) {
            NullReaderTest.assertEquals((String)"No Mark IOException message", (String)"No position has been marked", (String)e.getMessage());
        }
        while (position < 3) {
            NullReaderTest.assertEquals((String)("Read Before Mark [" + position + "]"), (int)position, (int)((Reader)((Object)reader)).read());
            ++position;
        }
        ((Reader)((Object)reader)).mark(readlimit);
        for (i = 0; i < 3; ++i) {
            NullReaderTest.assertEquals((String)("Read After Mark [" + i + "]"), (int)(position + i), (int)((Reader)((Object)reader)).read());
        }
        ((Reader)((Object)reader)).reset();
        for (i = 0; i < readlimit + 1; ++i) {
            NullReaderTest.assertEquals((String)("Read After Reset [" + i + "]"), (int)(position + i), (int)((Reader)((Object)reader)).read());
        }
        try {
            ((Reader)((Object)reader)).reset();
            NullReaderTest.fail((String)"Read limit exceeded, expected IOException ");
        }
        catch (IOException e) {
            NullReaderTest.assertEquals((String)"Read limit IOException message", (String)("Marked position [" + position + "] is no longer valid - passed the read limit [" + readlimit + "]"), (String)e.getMessage());
        }
    }

    public void testMarkNotSupported() throws Exception {
        TestNullReader reader = new TestNullReader(100, false, true);
        NullReaderTest.assertFalse((String)"Mark Should NOT be Supported", (boolean)((Reader)((Object)reader)).markSupported());
        try {
            ((Reader)((Object)reader)).mark(5);
            NullReaderTest.fail((String)"mark() should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            NullReaderTest.assertEquals((String)"mark() error message", (String)"Mark not supported", (String)e.getMessage());
        }
        try {
            ((Reader)((Object)reader)).reset();
            NullReaderTest.fail((String)"reset() should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            NullReaderTest.assertEquals((String)"reset() error message", (String)"Mark not supported", (String)e.getMessage());
        }
    }

    public void testSkip() throws Exception {
        TestNullReader reader = new TestNullReader(10, true, false);
        NullReaderTest.assertEquals((String)"Read 1", (int)0, (int)((Reader)((Object)reader)).read());
        NullReaderTest.assertEquals((String)"Read 2", (int)1, (int)((Reader)((Object)reader)).read());
        NullReaderTest.assertEquals((String)"Skip 1", (long)5L, (long)((Reader)((Object)reader)).skip(5L));
        NullReaderTest.assertEquals((String)"Read 3", (int)7, (int)((Reader)((Object)reader)).read());
        NullReaderTest.assertEquals((String)"Skip 2", (long)2L, (long)((Reader)((Object)reader)).skip(5L));
        NullReaderTest.assertEquals((String)"Skip 3 (EOF)", (long)-1L, (long)((Reader)((Object)reader)).skip(5L));
        try {
            ((Reader)((Object)reader)).skip(5L);
            NullReaderTest.fail((String)"Expected IOException for skipping after end of file");
        }
        catch (IOException e) {
            NullReaderTest.assertEquals((String)"Skip after EOF IOException message", (String)"Skip after end of file", (String)e.getMessage());
        }
    }

    private static final class TestNullReader
    extends NullReader {
        public TestNullReader(int size) {
            super((long)size);
        }

        public TestNullReader(int size, boolean markSupported, boolean throwEofException) {
            super((long)size, markSupported, throwEofException);
        }

        protected int processChar() {
            return (int)this.getPosition() - 1;
        }

        protected void processChars(char[] chars, int offset, int length) {
            int startPos = (int)this.getPosition() - length;
            for (int i = offset; i < length; ++i) {
                chars[i] = (char)(startPos + i);
            }
        }
    }
}

