/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import junit.framework.TestCase;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;

public class ClassLoaderObjectInputStreamTest
extends TestCase {
    public ClassLoaderObjectInputStreamTest(String name) {
        super(name);
    }

    public void testExpected() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(Boolean.FALSE);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ClassLoaderObjectInputStream clois = new ClassLoaderObjectInputStream(((Object)((Object)this)).getClass().getClassLoader(), (InputStream)bais);
        Boolean result = (Boolean)clois.readObject();
        ClassLoaderObjectInputStreamTest.assertTrue((result == false ? 1 : 0) != 0);
    }

    public void testResolveProxyClass() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(Boolean.FALSE);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ClassLoaderObjectInputStream clois = new ClassLoaderObjectInputStream(((Object)((Object)this)).getClass().getClassLoader(), (InputStream)bais);
        String[] interfaces = new String[]{Comparable.class.getName()};
        Class result = clois.resolveProxyClass(interfaces);
        ClassLoaderObjectInputStreamTest.assertTrue((String)"Assignable", (boolean)Comparable.class.isAssignableFrom(result));
    }
}

