/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.io.input.BrokenInputStream;

public class BrokenInputStreamTest
extends TestCase {
    private IOException exception;
    private InputStream stream;

    protected void setUp() {
        this.exception = new IOException("test exception");
        this.stream = new BrokenInputStream(this.exception);
    }

    public void testRead() {
        try {
            this.stream.read();
            BrokenInputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            BrokenInputStreamTest.assertEquals((Object)this.exception, (Object)e);
        }
        try {
            this.stream.read(new byte[1]);
            BrokenInputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            BrokenInputStreamTest.assertEquals((Object)this.exception, (Object)e);
        }
        try {
            this.stream.read(new byte[1], 0, 1);
            BrokenInputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            BrokenInputStreamTest.assertEquals((Object)this.exception, (Object)e);
        }
    }

    public void testAvailable() {
        try {
            this.stream.available();
            BrokenInputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            BrokenInputStreamTest.assertEquals((Object)this.exception, (Object)e);
        }
    }

    public void testSkip() {
        try {
            this.stream.skip(1L);
            BrokenInputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            BrokenInputStreamTest.assertEquals((Object)this.exception, (Object)e);
        }
    }

    public void testReset() {
        try {
            this.stream.reset();
            BrokenInputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            BrokenInputStreamTest.assertEquals((Object)this.exception, (Object)e);
        }
    }

    public void testClose() {
        try {
            this.stream.close();
            BrokenInputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            BrokenInputStreamTest.assertEquals((Object)this.exception, (Object)e);
        }
    }
}

