/*
 * Decompiled with CFR 0.152.
 */
package tool;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import tool.GraphicsUtils;

public class ScreenShot
extends JFrame {
    private static final long serialVersionUID = 1L;
    private BufferedImage image;
    private JLabel imageLabel;
    private int width;
    private int height;
    private int isExit;
    public boolean b;
    int x;
    int y;
    int xEnd;
    int yEnd;

    public Image getImage() {
        return this.image;
    }

    public ScreenShot(int isExit) throws AWTException, InterruptedException {
        this.width = Toolkit.getDefaultToolkit().getScreenSize().width;
        this.height = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.isExit = 1;
        this.b = true;
        this.isExit = isExit;
    }

    public ScreenShot() throws AWTException, InterruptedException {
        this.width = Toolkit.getDefaultToolkit().getScreenSize().width;
        this.height = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.isExit = 1;
        this.b = true;
        this.image = GraphicsUtils.getScreenImage(0, 0, this.width, this.height);
        this.imageLabel = new JLabel(new ImageIcon(this.image));
        this.imageLabel.setCursor(new Cursor(1));
        this.createAction();
        this.getContentPane().add(this.imageLabel);
        this.setUndecorated(true);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        this.setExtendedState(6);
    }

    private void createAction() {
        this.imageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isMetaDown()) {
                    if (ScreenShot.this.isExit == 0) {
                        System.exit(0);
                    } else {
                        ScreenShot.this.b = false;
                        ScreenShot.this.dispose();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ScreenShot.this.x = e.getX();
                ScreenShot.this.y = e.getY();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ScreenShot.this.xEnd = e.getX();
                ScreenShot.this.yEnd = e.getY();
                if (ScreenShot.this.x == ScreenShot.this.xEnd | ScreenShot.this.y == ScreenShot.this.yEnd) {
                    ScreenShot.this.image = null;
                } else {
                    try {
                        Robot robot = new Robot();
                        ScreenShot.this.image = robot.createScreenCapture(new Rectangle(Math.min(ScreenShot.this.x, ScreenShot.this.xEnd), Math.min(ScreenShot.this.y, ScreenShot.this.yEnd), Math.abs(ScreenShot.this.xEnd - ScreenShot.this.x), Math.abs(ScreenShot.this.yEnd - ScreenShot.this.y)));
                    }
                    catch (AWTException aWTException) {
                        System.out.println("\u53d6\u5716\u932f\u8aa4");
                    }
                }
                System.out.println("x1=" + ScreenShot.this.x + "y1=" + ScreenShot.this.y + "x2=" + ScreenShot.this.xEnd + "y2=" + ScreenShot.this.yEnd);
                ScreenShot.this.b = false;
                ScreenShot.this.dispose();
            }
        });
        this.imageLabel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ScreenShot.this.xEnd = e.getX();
                ScreenShot.this.yEnd = e.getY();
                BufferedImage bi = new BufferedImage(ScreenShot.this.image.getWidth(null), ScreenShot.this.image.getHeight(null), 1);
                Graphics2D g2d = (Graphics2D)bi.getGraphics();
                g2d.drawImage((Image)ScreenShot.this.image, 0, 0, null);
                g2d.setColor(Color.RED);
                g2d.drawRect(Math.min(ScreenShot.this.x, ScreenShot.this.xEnd) - 1, Math.min(ScreenShot.this.y, ScreenShot.this.yEnd) - 1, Math.abs(ScreenShot.this.xEnd - ScreenShot.this.x) + 1, Math.abs(ScreenShot.this.yEnd - ScreenShot.this.y) + 1);
                g2d.dispose();
                Graphics g = ScreenShot.this.imageLabel.getGraphics();
                g.drawImage(bi, 0, 0, null);
                g.dispose();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                ScreenShot.this.x = e.getX();
                ScreenShot.this.y = e.getY();
                BufferedImage bi = new BufferedImage(ScreenShot.this.image.getWidth(null), ScreenShot.this.image.getHeight(null), 1);
                Graphics2D g2d = (Graphics2D)bi.getGraphics();
                g2d.drawImage((Image)ScreenShot.this.image, 0, 0, null);
                g2d.setColor(Color.RED);
                g2d.drawLine(ScreenShot.this.x, 0, ScreenShot.this.x, ScreenShot.this.height);
                g2d.drawLine(0, ScreenShot.this.y, ScreenShot.this.width, ScreenShot.this.y);
                g2d.dispose();
                Graphics g = ScreenShot.this.imageLabel.getGraphics();
                g.drawImage(bi, 0, 0, null);
                g.dispose();
            }
        });
    }

    public static void main(String[] args) throws AWTException, InterruptedException {
        String filename = new SimpleDateFormat("MM-dd-HH-mm-ss").format(new Date()) + ".png";
        ScreenShot s = new ScreenShot();
    }
}

