/*
 * Decompiled with CFR 0.152.
 */
package tool;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class ImagePrintable
implements Printable {
    private double x;
    private double y;
    private double width;
    private int orientation;
    private BufferedImage image;
    private int pagesize = 1;

    public ImagePrintable(PrinterJob printJob, BufferedImage image, int pagesize) {
        PageFormat pageFormat = printJob.defaultPage();
        this.x = pageFormat.getImageableX();
        this.y = pageFormat.getImageableY();
        this.width = pageFormat.getImageableWidth();
        this.orientation = pageFormat.getOrientation();
        this.image = image;
        this.pagesize = pagesize;
    }

    ImagePrintable(PrinterJob printJob, BufferedImage image) {
        PageFormat pageFormat = printJob.defaultPage();
        this.x = pageFormat.getImageableX();
        this.y = pageFormat.getImageableY();
        this.width = pageFormat.getImageableWidth();
        this.orientation = pageFormat.getOrientation();
        this.image = image;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex < this.pagesize) {
            int pWidth = 0;
            int pHeight = 0;
            if (this.orientation == 1) {
                pWidth = (int)Math.min(this.width, (double)this.image.getWidth());
                pHeight = pWidth * this.image.getHeight() / this.image.getWidth();
            } else {
                pHeight = (int)Math.min(this.width, (double)this.image.getHeight());
                pWidth = pHeight * this.image.getWidth() / this.image.getHeight();
            }
            g.drawImage(this.image, (int)this.x, (int)this.y, pWidth, pHeight, null);
            return 0;
        }
        return 1;
    }
}

