/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.io.output.WriterOutputStream;

public class WriterOutputStreamTest
extends TestCase {
    private static final String TEST_STRING = "\u00e0 peine arriv\u00e9s nous entr\u00e2mes dans sa chambre";
    private static final String LARGE_TEST_STRING;
    private Random random = new Random();

    private void testWithSingleByteWrite(String testString, String charsetName) throws IOException {
        byte[] bytes = testString.getBytes(charsetName);
        StringWriter writer = new StringWriter();
        WriterOutputStream out = new WriterOutputStream((Writer)writer, charsetName);
        for (byte b : bytes) {
            out.write((int)b);
        }
        out.close();
        WriterOutputStreamTest.assertEquals((String)testString, (String)writer.toString());
    }

    private void testWithBufferedWrite(String testString, String charsetName) throws IOException {
        int length;
        byte[] expected = testString.getBytes(charsetName);
        StringWriter writer = new StringWriter();
        WriterOutputStream out = new WriterOutputStream((Writer)writer, charsetName);
        for (int offset = 0; offset < expected.length; offset += length) {
            length = Math.min(this.random.nextInt(128), expected.length - offset);
            out.write(expected, offset, length);
        }
        out.close();
        WriterOutputStreamTest.assertEquals((String)testString, (String)writer.toString());
    }

    public void testUTF8WithSingleByteWrite() throws IOException {
        this.testWithSingleByteWrite(TEST_STRING, "UTF-8");
    }

    public void testLargeUTF8WithSingleByteWrite() throws IOException {
        this.testWithSingleByteWrite(LARGE_TEST_STRING, "UTF-8");
    }

    public void testUTF8WithBufferedWrite() throws IOException {
        this.testWithBufferedWrite(TEST_STRING, "UTF-8");
    }

    public void testLargeUTF8WithBufferedWrite() throws IOException {
        this.testWithBufferedWrite(LARGE_TEST_STRING, "UTF-8");
    }

    public void testUTF16WithSingleByteWrite() throws IOException {
        this.testWithSingleByteWrite(TEST_STRING, "UTF-16");
    }

    public void testUTF16WithBufferedWrite() throws IOException {
        this.testWithBufferedWrite(TEST_STRING, "UTF-16");
    }

    public void testUTF16BEWithSingleByteWrite() throws IOException {
        this.testWithSingleByteWrite(TEST_STRING, "UTF-16BE");
    }

    public void testUTF16BEWithBufferedWrite() throws IOException {
        this.testWithBufferedWrite(TEST_STRING, "UTF-16BE");
    }

    public void testUTF16LEWithSingleByteWrite() throws IOException {
        this.testWithSingleByteWrite(TEST_STRING, "UTF-16LE");
    }

    public void testUTF16LEWithBufferedWrite() throws IOException {
        this.testWithBufferedWrite(TEST_STRING, "UTF-16LE");
    }

    public void testFlush() throws IOException {
        StringWriter writer = new StringWriter();
        WriterOutputStream out = new WriterOutputStream((Writer)writer, "us-ascii", 1024, false);
        out.write("abc".getBytes("us-ascii"));
        WriterOutputStreamTest.assertEquals((int)0, (int)writer.getBuffer().length());
        out.flush();
        WriterOutputStreamTest.assertEquals((String)"abc", (String)writer.toString());
    }

    public void testWriteImmediately() throws IOException {
        StringWriter writer = new StringWriter();
        WriterOutputStream out = new WriterOutputStream((Writer)writer, "us-ascii", 1024, true);
        out.write("abc".getBytes("us-ascii"));
        WriterOutputStreamTest.assertEquals((String)"abc", (String)writer.toString());
    }

    static {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            buffer.append(TEST_STRING);
        }
        LARGE_TEST_STRING = buffer.toString();
    }
}

