/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.LockableFileWriter;
import org.apache.commons.io.testtools.FileBasedTestCase;

public class LockableFileWriterTest
extends FileBasedTestCase {
    private File file;
    private File lockDir;
    private File lockFile;
    private File altLockDir;
    private File altLockFile;

    public LockableFileWriterTest(String name) {
        super(name);
    }

    public void setUp() {
        this.file = new File(LockableFileWriterTest.getTestDirectory(), "testlockfile");
        this.lockDir = new File(System.getProperty("java.io.tmpdir"));
        this.lockFile = new File(this.lockDir, this.file.getName() + ".lck");
        this.altLockDir = LockableFileWriterTest.getTestDirectory();
        this.altLockFile = new File(this.altLockDir, this.file.getName() + ".lck");
    }

    public void tearDown() {
        this.file.delete();
        this.lockFile.delete();
        this.altLockFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileLocked() throws IOException {
        LockableFileWriter lfw1 = null;
        LockableFileWriter lfw2 = null;
        LockableFileWriter lfw3 = null;
        try {
            String msg;
            lfw1 = new LockableFileWriter(this.file);
            LockableFileWriterTest.assertTrue((boolean)this.file.exists());
            LockableFileWriterTest.assertTrue((boolean)this.lockFile.exists());
            try {
                lfw2 = new LockableFileWriter(this.file);
                LockableFileWriterTest.fail((String)"Somehow able to open a locked file. ");
            }
            catch (IOException ioe) {
                msg = ioe.getMessage();
                LockableFileWriterTest.assertTrue((String)"Exception message does not start correctly. ", (boolean)msg.startsWith("Can't write file, lock "));
                LockableFileWriterTest.assertTrue((boolean)this.file.exists());
                LockableFileWriterTest.assertTrue((boolean)this.lockFile.exists());
            }
            try {
                lfw3 = new LockableFileWriter(this.file);
                LockableFileWriterTest.fail((String)"Somehow able to open a locked file. ");
            }
            catch (IOException ioe) {
                msg = ioe.getMessage();
                LockableFileWriterTest.assertTrue((String)"Exception message does not start correctly. ", (boolean)msg.startsWith("Can't write file, lock "));
                LockableFileWriterTest.assertTrue((boolean)this.file.exists());
                LockableFileWriterTest.assertTrue((boolean)this.lockFile.exists());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(lfw1);
            IOUtils.closeQuietly(lfw2);
            IOUtils.closeQuietly(lfw3);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)lfw1);
        IOUtils.closeQuietly((Writer)lfw2);
        IOUtils.closeQuietly((Writer)lfw3);
        LockableFileWriterTest.assertTrue((boolean)this.file.exists());
        LockableFileWriterTest.assertFalse((boolean)this.lockFile.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAlternateLockDir() throws IOException {
        LockableFileWriter lfw1 = null;
        LockableFileWriter lfw2 = null;
        try {
            lfw1 = new LockableFileWriter(this.file, true, this.altLockDir.getAbsolutePath());
            LockableFileWriterTest.assertTrue((boolean)this.file.exists());
            LockableFileWriterTest.assertTrue((boolean)this.altLockFile.exists());
            try {
                lfw2 = new LockableFileWriter(this.file, true, this.altLockDir.getAbsolutePath());
                LockableFileWriterTest.fail((String)"Somehow able to open a locked file. ");
            }
            catch (IOException ioe) {
                String msg = ioe.getMessage();
                LockableFileWriterTest.assertTrue((String)"Exception message does not start correctly. ", (boolean)msg.startsWith("Can't write file, lock "));
                LockableFileWriterTest.assertTrue((boolean)this.file.exists());
                LockableFileWriterTest.assertTrue((boolean)this.altLockFile.exists());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(lfw1);
            IOUtils.closeQuietly(lfw2);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)lfw1);
        IOUtils.closeQuietly((Writer)lfw2);
        LockableFileWriterTest.assertTrue((boolean)this.file.exists());
        LockableFileWriterTest.assertFalse((boolean)this.altLockFile.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileNotLocked() throws IOException {
        LockableFileWriter lfw1 = null;
        try {
            lfw1 = new LockableFileWriter(this.file);
            LockableFileWriterTest.assertTrue((boolean)this.file.exists());
            LockableFileWriterTest.assertTrue((boolean)this.lockFile.exists());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(lfw1);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)lfw1);
        LockableFileWriterTest.assertTrue((boolean)this.file.exists());
        LockableFileWriterTest.assertFalse((boolean)this.lockFile.exists());
        LockableFileWriter lfw2 = null;
        try {
            lfw2 = new LockableFileWriter(this.file);
            LockableFileWriterTest.assertTrue((boolean)this.file.exists());
            LockableFileWriterTest.assertTrue((boolean)this.lockFile.exists());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(lfw2);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)lfw2);
        LockableFileWriterTest.assertTrue((boolean)this.file.exists());
        LockableFileWriterTest.assertFalse((boolean)this.lockFile.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConstructor_File_encoding_badEncoding() throws IOException {
        LockableFileWriter writer = null;
        try {
            writer = new LockableFileWriter(this.file, "BAD-ENCODE");
            LockableFileWriterTest.fail();
        }
        catch (UnsupportedCharsetException ex) {
            try {
                LockableFileWriterTest.assertFalse((boolean)this.file.exists());
                LockableFileWriterTest.assertFalse((boolean)this.lockFile.exists());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
        LockableFileWriterTest.assertFalse((boolean)this.file.exists());
        LockableFileWriterTest.assertFalse((boolean)this.lockFile.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConstructor_File_directory() {
        LockableFileWriter writer = null;
        try {
            writer = new LockableFileWriter(LockableFileWriterTest.getTestDirectory());
            LockableFileWriterTest.fail();
        }
        catch (IOException ex) {
            try {
                LockableFileWriterTest.assertFalse((boolean)this.file.exists());
                LockableFileWriterTest.assertFalse((boolean)this.lockFile.exists());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
        LockableFileWriterTest.assertFalse((boolean)this.file.exists());
        LockableFileWriterTest.assertFalse((boolean)this.lockFile.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConstructor_File_nullFile() throws IOException {
        LockableFileWriter writer = null;
        try {
            writer = new LockableFileWriter((File)null);
            LockableFileWriterTest.fail();
        }
        catch (NullPointerException ex) {
            try {
                LockableFileWriterTest.assertFalse((boolean)this.file.exists());
                LockableFileWriterTest.assertFalse((boolean)this.lockFile.exists());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
        LockableFileWriterTest.assertFalse((boolean)this.file.exists());
        LockableFileWriterTest.assertFalse((boolean)this.lockFile.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConstructor_fileName_nullFile() throws IOException {
        LockableFileWriter writer = null;
        try {
            writer = new LockableFileWriter((String)null);
            LockableFileWriterTest.fail();
        }
        catch (NullPointerException ex) {
            try {
                LockableFileWriterTest.assertFalse((boolean)this.file.exists());
                LockableFileWriterTest.assertFalse((boolean)this.lockFile.exists());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
        LockableFileWriterTest.assertFalse((boolean)this.file.exists());
        LockableFileWriterTest.assertFalse((boolean)this.lockFile.exists());
    }
}

