/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.io.output.BrokenOutputStream;

public class BrokenOutputStreamTest
extends TestCase {
    private IOException exception;
    private OutputStream stream;

    protected void setUp() {
        this.exception = new IOException("test exception");
        this.stream = new BrokenOutputStream(this.exception);
    }

    public void testWrite() {
        try {
            this.stream.write(1);
            BrokenOutputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            BrokenOutputStreamTest.assertEquals((Object)this.exception, (Object)e);
        }
        try {
            this.stream.write(new byte[1]);
            BrokenOutputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            BrokenOutputStreamTest.assertEquals((Object)this.exception, (Object)e);
        }
        try {
            this.stream.write(new byte[1], 0, 1);
            BrokenOutputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            BrokenOutputStreamTest.assertEquals((Object)this.exception, (Object)e);
        }
    }

    public void testFlush() {
        try {
            this.stream.flush();
            BrokenOutputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            BrokenOutputStreamTest.assertEquals((Object)this.exception, (Object)e);
        }
    }

    public void testClose() {
        try {
            this.stream.close();
            BrokenOutputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            BrokenOutputStreamTest.assertEquals((Object)this.exception, (Object)e);
        }
    }
}

