/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;

public class CollectionFileListener
implements FileAlterationListener,
Serializable {
    private final boolean clearOnStart;
    private final Collection<File> createdFiles = new ArrayList<File>();
    private final Collection<File> changedFiles = new ArrayList<File>();
    private final Collection<File> deletedFiles = new ArrayList<File>();
    private final Collection<File> createdDirectories = new ArrayList<File>();
    private final Collection<File> changedDirectories = new ArrayList<File>();
    private final Collection<File> deletedDirectories = new ArrayList<File>();

    public CollectionFileListener(boolean clearOnStart) {
        this.clearOnStart = clearOnStart;
    }

    public void onStart(FileAlterationObserver observer) {
        if (this.clearOnStart) {
            this.clear();
        }
    }

    public void clear() {
        this.createdFiles.clear();
        this.changedFiles.clear();
        this.deletedFiles.clear();
        this.createdDirectories.clear();
        this.changedDirectories.clear();
        this.deletedDirectories.clear();
    }

    public Collection<File> getChangedDirectories() {
        return this.changedDirectories;
    }

    public Collection<File> getChangedFiles() {
        return this.changedFiles;
    }

    public Collection<File> getCreatedDirectories() {
        return this.createdDirectories;
    }

    public Collection<File> getCreatedFiles() {
        return this.createdFiles;
    }

    public Collection<File> getDeletedDirectories() {
        return this.deletedDirectories;
    }

    public Collection<File> getDeletedFiles() {
        return this.deletedFiles;
    }

    public void onDirectoryCreate(File directory) {
        this.createdDirectories.add(directory);
    }

    public void onDirectoryChange(File directory) {
        this.changedDirectories.add(directory);
    }

    public void onDirectoryDelete(File directory) {
        this.deletedDirectories.add(directory);
    }

    public void onFileCreate(File file) {
        this.createdFiles.add(file);
    }

    public void onFileChange(File file) {
        this.changedFiles.add(file);
    }

    public void onFileDelete(File file) {
        this.deletedFiles.add(file);
    }

    public void onStop(FileAlterationObserver observer) {
    }
}

