/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.testtools.FileBasedTestCase;

public class TailerTest
extends FileBasedTestCase {
    private Tailer tailer;

    public TailerTest(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        if (this.tailer != null) {
            this.tailer.stop();
            Thread.sleep(1000L);
        }
        FileUtils.deleteDirectory((File)TailerTest.getTestDirectory());
        Thread.sleep(1000L);
    }

    public void testLongFile() throws Exception {
        long delay = 50L;
        File file = new File(TailerTest.getTestDirectory(), "testLongFile.txt");
        this.createFile(file, 0L);
        FileWriter writer = new FileWriter(file, true);
        for (int i = 0; i < 100000; ++i) {
            writer.write("LineLineLineLineLineLineLineLineLineLine\n");
        }
        writer.write("SBTOURIST\n");
        IOUtils.closeQuietly((Writer)writer);
        TestTailerListener listener = new TestTailerListener();
        this.tailer = new Tailer(file, (TailerListener)listener, delay, false);
        long start = System.currentTimeMillis();
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        List<String> lines = listener.getLines();
        while (lines.isEmpty() || !lines.get(lines.size() - 1).equals("SBTOURIST")) {
            lines = listener.getLines();
        }
        System.out.println("Elapsed: " + (System.currentTimeMillis() - start));
        listener.clear();
    }

    public void testBufferBreak() throws Exception {
        long delay = 50L;
        File file = new File(TailerTest.getTestDirectory(), "testBufferBreak.txt");
        this.createFile(file, 0L);
        this.writeString(file, "SBTOURIST\n");
        TestTailerListener listener = new TestTailerListener();
        this.tailer = new Tailer(file, (TailerListener)listener, delay, false, 1);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        List<String> lines = listener.getLines();
        while (lines.isEmpty() || !lines.get(lines.size() - 1).equals("SBTOURIST")) {
            lines = listener.getLines();
        }
        listener.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTailerEof() throws Exception {
        long delay = 50L;
        File file = new File(TailerTest.getTestDirectory(), "tailer2-test.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        Tailer tailer = new Tailer(file, (TailerListener)listener, delay, false);
        Thread thread = new Thread((Runnable)tailer);
        thread.start();
        Writer writer = null;
        try {
            this.writeString(file, "Line");
            Thread.sleep(delay * 2L);
            List<String> lines = listener.getLines();
            TailerTest.assertEquals((String)"1 line count", (int)0, (int)lines.size());
            this.writeString(file, " one\n");
            Thread.sleep(delay * 2L);
            lines = listener.getLines();
            TailerTest.assertEquals((String)"1 line count", (int)1, (int)lines.size());
            TailerTest.assertEquals((String)"1 line 1", (String)"Line one", (String)lines.get(0));
            listener.clear();
        }
        finally {
            tailer.stop();
            Thread.sleep(delay * 2L);
            IOUtils.closeQuietly(writer);
        }
    }

    public void testTailer() throws Exception {
        long delayMillis = 50L;
        File file = new File(TailerTest.getTestDirectory(), "tailer1-test.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        String osname = System.getProperty("os.name");
        boolean isWindows = osname.startsWith("Windows");
        this.tailer = new Tailer(file, (TailerListener)listener, delayMillis, false, isWindows);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        this.write(file, "Line one", "Line two");
        long testDelayMillis = delayMillis * 10L;
        Thread.sleep(testDelayMillis);
        List<String> lines = listener.getLines();
        TailerTest.assertEquals((String)"1 line count", (int)2, (int)lines.size());
        TailerTest.assertEquals((String)"1 line 1", (String)"Line one", (String)lines.get(0));
        TailerTest.assertEquals((String)"1 line 2", (String)"Line two", (String)lines.get(1));
        listener.clear();
        this.write(file, "Line three");
        Thread.sleep(testDelayMillis);
        lines = listener.getLines();
        TailerTest.assertEquals((String)"2 line count", (int)1, (int)lines.size());
        TailerTest.assertEquals((String)"2 line 3", (String)"Line three", (String)lines.get(0));
        listener.clear();
        lines = FileUtils.readLines((File)file);
        TailerTest.assertEquals((String)"3 line count", (int)3, (int)lines.size());
        TailerTest.assertEquals((String)"3 line 1", (String)"Line one", (String)((String)lines.get(0)));
        TailerTest.assertEquals((String)"3 line 2", (String)"Line two", (String)((String)lines.get(1)));
        TailerTest.assertEquals((String)"3 line 3", (String)"Line three", (String)((String)lines.get(2)));
        file.delete();
        boolean exists = file.exists();
        TailerTest.assertFalse((String)"File should not exist", (boolean)exists);
        this.createFile(file, 0L);
        Thread.sleep(testDelayMillis);
        this.write(file, "Line four");
        Thread.sleep(testDelayMillis);
        lines = listener.getLines();
        TailerTest.assertEquals((String)"4 line count", (int)1, (int)lines.size());
        TailerTest.assertEquals((String)"4 line 3", (String)"Line four", (String)lines.get(0));
        listener.clear();
        this.tailer.stop();
        this.tailer = null;
        thread.interrupt();
        Thread.sleep(testDelayMillis);
        this.write(file, "Line five");
        TailerTest.assertEquals((String)"4 line count", (int)0, (int)listener.getLines().size());
        TailerTest.assertNull((String)"Should not generate Exception", (Object)listener.exception);
        TailerTest.assertEquals((String)"Expected init to be called", (int)1, (int)listener.initialised);
        TailerTest.assertEquals((String)"fileNotFound should not be called", (int)0, (int)listener.notFound);
        TailerTest.assertEquals((String)"fileRotated should be be called", (int)1, (int)listener.rotated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createFile(File file, long size) throws IOException {
        super.createFile(file, size);
        RandomAccessFile reader = null;
        try {
            while (reader == null) {
                try {
                    reader = new RandomAccessFile(file.getPath(), "r");
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {}
            }
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(File file, String ... lines) throws Exception {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file, true);
            for (String line : lines) {
                writer.write(line + "\n");
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeString(File file, String ... strings) throws Exception {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file, true);
            for (String string : strings) {
                writer.write(string);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public void testStopWithNoFile() throws Exception {
        File file = new File(TailerTest.getTestDirectory(), "nosuchfile");
        TailerTest.assertFalse((String)"nosuchfile should not exist", (boolean)file.exists());
        TestTailerListener listener = new TestTailerListener();
        int delay = 100;
        int idle = 50;
        this.tailer = Tailer.create((File)file, (TailerListener)listener, (long)delay, (boolean)false);
        Thread.sleep(idle);
        this.tailer.stop();
        this.tailer = null;
        Thread.sleep(delay + idle);
        TailerTest.assertNull((String)"Should not generate Exception", (Object)listener.exception);
        TailerTest.assertEquals((String)"Expected init to be called", (int)1, (int)listener.initialised);
        TailerTest.assertTrue((String)"fileNotFound should be called", (listener.notFound > 0 ? 1 : 0) != 0);
        TailerTest.assertEquals((String)"fileRotated should be not be called", (int)0, (int)listener.rotated);
    }

    public void testStopWithNoFileUsingExecutor() throws Exception {
        File file = new File(TailerTest.getTestDirectory(), "nosuchfile");
        TailerTest.assertFalse((String)"nosuchfile should not exist", (boolean)file.exists());
        TestTailerListener listener = new TestTailerListener();
        int delay = 100;
        int idle = 50;
        this.tailer = new Tailer(file, (TailerListener)listener, (long)delay, false);
        ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(1);
        exec.execute((Runnable)this.tailer);
        Thread.sleep(idle);
        this.tailer.stop();
        this.tailer = null;
        Thread.sleep(delay + idle);
        TailerTest.assertNull((String)"Should not generate Exception", (Object)listener.exception);
        TailerTest.assertEquals((String)"Expected init to be called", (int)1, (int)listener.initialised);
        TailerTest.assertTrue((String)"fileNotFound should be called", (listener.notFound > 0 ? 1 : 0) != 0);
        TailerTest.assertEquals((String)"fileRotated should be not be called", (int)0, (int)listener.rotated);
    }

    public void testIO335() throws Exception {
        long delayMillis = 50L;
        File file = new File(TailerTest.getTestDirectory(), "tailer-testio334.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        this.tailer = new Tailer(file, (TailerListener)listener, delayMillis, false);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        this.writeString(file, "CRLF\r\n", "LF\n", "CR\r", "CRCR\r\r", "trail");
        long testDelayMillis = delayMillis * 10L;
        Thread.sleep(testDelayMillis);
        List<String> lines = listener.getLines();
        TailerTest.assertEquals((String)"line count", (int)4, (int)lines.size());
        TailerTest.assertEquals((String)"line 1", (String)"CRLF", (String)lines.get(0));
        TailerTest.assertEquals((String)"line 2", (String)"LF", (String)lines.get(1));
        TailerTest.assertEquals((String)"line 3", (String)"CR", (String)lines.get(2));
        TailerTest.assertEquals((String)"line 4", (String)"CRCR\r", (String)lines.get(3));
        this.tailer.stop();
        this.tailer = null;
        thread.interrupt();
        Thread.sleep(testDelayMillis);
    }

    private static class TestTailerListener
    implements TailerListener {
        private final List<String> lines = Collections.synchronizedList(new ArrayList());
        volatile Exception exception = null;
        volatile int notFound = 0;
        volatile int rotated = 0;
        volatile int initialised = 0;

        private TestTailerListener() {
        }

        public void handle(String line) {
            this.lines.add(line);
        }

        public List<String> getLines() {
            return this.lines;
        }

        public void clear() {
            this.lines.clear();
        }

        public void handle(Exception e) {
            this.exception = e;
        }

        public void init(Tailer tailer) {
            ++this.initialised;
        }

        public void fileNotFound() {
            ++this.notFound;
        }

        public void fileRotated() {
            ++this.rotated;
        }
    }
}

