/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.io.input.SwappedDataInputStream;

public class SwappedDataInputStreamTest
extends TestCase {
    private SwappedDataInputStream sdis;
    private byte[] bytes;

    public SwappedDataInputStreamTest(String name) {
        super(name);
    }

    public void setUp() {
        this.bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        ByteArrayInputStream bais = new ByteArrayInputStream(this.bytes);
        this.sdis = new SwappedDataInputStream((InputStream)bais);
    }

    public void tearDown() {
        this.sdis = null;
    }

    public void testReadBoolean() throws IOException {
        this.bytes = new byte[]{0, 1, 2};
        ByteArrayInputStream bais = new ByteArrayInputStream(this.bytes);
        SwappedDataInputStream sdis = new SwappedDataInputStream((InputStream)bais);
        SwappedDataInputStreamTest.assertEquals((boolean)false, (boolean)sdis.readBoolean());
        SwappedDataInputStreamTest.assertEquals((boolean)true, (boolean)sdis.readBoolean());
        SwappedDataInputStreamTest.assertEquals((boolean)true, (boolean)sdis.readBoolean());
    }

    public void testReadByte() throws IOException {
        SwappedDataInputStreamTest.assertEquals((int)1, (int)this.sdis.readByte());
    }

    public void testReadChar() throws IOException {
        SwappedDataInputStreamTest.assertEquals((char)'\u0201', (char)this.sdis.readChar());
    }

    public void testReadDouble() throws IOException {
        SwappedDataInputStreamTest.assertEquals((double)Double.longBitsToDouble(578437695752307201L), (double)this.sdis.readDouble(), (double)0.0);
    }

    public void testReadFloat() throws IOException {
        SwappedDataInputStreamTest.assertEquals((float)Float.intBitsToFloat(67305985), (float)this.sdis.readFloat(), (float)0.0f);
    }

    public void testReadFully() throws IOException {
        byte[] bytesIn = new byte[8];
        this.sdis.readFully(bytesIn);
        for (int i = 0; i < 8; ++i) {
            SwappedDataInputStreamTest.assertEquals((byte)this.bytes[i], (byte)bytesIn[i]);
        }
    }

    public void testReadInt() throws IOException {
        SwappedDataInputStreamTest.assertEquals((int)67305985, (int)this.sdis.readInt());
    }

    public void testReadLine() throws IOException {
        try {
            this.sdis.readLine();
            SwappedDataInputStreamTest.fail((String)"readLine should be unsupported. ");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testReadLong() throws IOException {
        SwappedDataInputStreamTest.assertEquals((long)578437695752307201L, (long)this.sdis.readLong());
    }

    public void testReadShort() throws IOException {
        SwappedDataInputStreamTest.assertEquals((short)513, (short)this.sdis.readShort());
    }

    public void testReadUnsignedByte() throws IOException {
        SwappedDataInputStreamTest.assertEquals((int)1, (int)this.sdis.readUnsignedByte());
    }

    public void testReadUnsignedShort() throws IOException {
        SwappedDataInputStreamTest.assertEquals((int)513, (int)this.sdis.readUnsignedShort());
    }

    public void testReadUTF() throws IOException {
        try {
            this.sdis.readUTF();
            SwappedDataInputStreamTest.fail((String)"readUTF should be unsupported. ");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testSkipBytes() throws IOException {
        this.sdis.skipBytes(4);
        SwappedDataInputStreamTest.assertEquals((int)134678021, (int)this.sdis.readInt());
    }
}

