/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ReversedLinesFileReaderTestParamBlockSize {
    private static final String UTF_8 = "UTF-8";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private ReversedLinesFileReader reversedLinesFileReader;
    private int testParamBlockSize;
    private static final String TEST_LINE = "A Test Line. Special chars: \u00c4\u00e4\u00dc\u00fc\u00d6\u00f6\u00df \u00c3\u00e1\u00e9\u00ed\u00ef\u00e7\u00f1\u00c2 \u00a9\u00b5\u00a5\u00a3\u00b1\u00b2\u00ae";
    private static final String TEST_LINE_SHIFT_JIS1 = "Hiragana letters: \u3041\u3042\u3043\u3044\u3045";
    private static final String TEST_LINE_SHIFT_JIS2 = "Kanji letters: \u660e\u8f38\u5b50\u4eac";

    @Parameterized.Parameters
    public static Collection<Integer[]> blockSizes() {
        return Arrays.asList({1}, {3}, {8}, {256}, {4096});
    }

    public ReversedLinesFileReaderTestParamBlockSize(Integer testWithBlockSize) {
        this.testParamBlockSize = testWithBlockSize;
    }

    @After
    public void closeReader() {
        try {
            this.reversedLinesFileReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testIsoFileDefaults() throws URISyntaxException, IOException {
        File testFileIso = new File(this.getClass().getResource("/test-file-iso8859-1.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileIso, this.testParamBlockSize, ISO_8859_1);
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @Test
    public void testUTF8FileWindowsBreaks() throws URISyntaxException, IOException {
        File testFileIso = new File(this.getClass().getResource("/test-file-utf8-win-linebr.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileIso, this.testParamBlockSize, UTF_8);
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @Test
    public void testUTF8FileCRBreaks() throws URISyntaxException, IOException {
        File testFileIso = new File(this.getClass().getResource("/test-file-utf8-cr-only.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileIso, this.testParamBlockSize, UTF_8);
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @Test
    public void testUTF8File() throws URISyntaxException, IOException {
        File testFileIso = new File(this.getClass().getResource("/test-file-utf8.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileIso, this.testParamBlockSize, UTF_8);
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @Test
    public void testEmptyFile() throws URISyntaxException, IOException {
        File testFileEmpty = new File(this.getClass().getResource("/test-file-empty.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileEmpty, this.testParamBlockSize, UTF_8);
        Assert.assertNull((Object)this.reversedLinesFileReader.readLine());
    }

    @Test
    public void testUTF16BEFile() throws URISyntaxException, IOException {
        File testFileUTF16BE = new File(this.getClass().getResource("/test-file-utf16be.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileUTF16BE, this.testParamBlockSize, "UTF-16BE");
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @Test
    public void testUTF16LEFile() throws URISyntaxException, IOException {
        File testFileUTF16LE = new File(this.getClass().getResource("/test-file-utf16le.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileUTF16LE, this.testParamBlockSize, "UTF-16LE");
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @Test
    public void testShiftJISFile() throws URISyntaxException, IOException {
        File testFileShiftJIS = new File(this.getClass().getResource("/test-file-shiftjis.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileShiftJIS, this.testParamBlockSize, "Shift_JIS");
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks(TEST_LINE_SHIFT_JIS2, this.reversedLinesFileReader.readLine());
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks(TEST_LINE_SHIFT_JIS1, this.reversedLinesFileReader.readLine());
    }

    @Test
    public void testFileSizeIsExactMultipleOfBlockSize() throws URISyntaxException, IOException {
        int blockSize = 10;
        File testFile20Bytes = new File(this.getClass().getResource("/test-file-20byteslength.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFile20Bytes, blockSize, ISO_8859_1);
        String testLine = "123456789";
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks(testLine, this.reversedLinesFileReader.readLine());
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks(testLine, this.reversedLinesFileReader.readLine());
    }

    @Test
    public void testUTF8FileWindowsBreaksSmallBlockSize2VerifyBlockSpanningNewLines() throws URISyntaxException, IOException {
        File testFileUtf8 = new File(this.getClass().getResource("/test-file-utf8-win-linebr.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileUtf8, this.testParamBlockSize, UTF_8);
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @Test
    public void testIsoFileManyWindowsBreaksSmallBlockSize2VerifyBlockSpanningNewLines() throws URISyntaxException, IOException {
        File testFileIso = new File(this.getClass().getResource("/test-file-iso8859-1-shortlines-win-linebr.bin").toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileIso, this.testParamBlockSize, ISO_8859_1);
        for (int i = 3; i > 0; --i) {
            for (int j = 1; j <= 3; ++j) {
                ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks("", this.reversedLinesFileReader.readLine());
            }
            ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks("" + i, this.reversedLinesFileReader.readLine());
        }
    }

    @Test(expected=UnsupportedEncodingException.class)
    public void testUnsupportedEncodingUTF16() throws URISyntaxException, IOException {
        File testFileEmpty = new File(this.getClass().getResource("/test-file-empty.bin").toURI());
        new ReversedLinesFileReader(testFileEmpty, this.testParamBlockSize, "UTF-16");
    }

    @Test(expected=UnsupportedEncodingException.class)
    public void testUnsupportedEncodingBig5() throws URISyntaxException, IOException {
        File testFileEncodingBig5 = new File(this.getClass().getResource("/test-file-empty.bin").toURI());
        new ReversedLinesFileReader(testFileEncodingBig5, this.testParamBlockSize, "Big5");
    }

    private void assertFileWithShrinkingTestLines(ReversedLinesFileReader reversedLinesFileReader) throws IOException {
        String line = null;
        int lineCount = 0;
        while ((line = reversedLinesFileReader.readLine()) != null) {
            ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks("Line " + ++lineCount + " is not matching", TEST_LINE.substring(0, lineCount), line);
        }
    }

    static void assertEqualsAndNoLineBreaks(String msg, String expected, String actual) {
        if (actual != null) {
            Assert.assertFalse((String)("Line contains \\n: line=" + actual), (boolean)actual.contains("\n"));
            Assert.assertFalse((String)("Line contains \\r: line=" + actual), (boolean)actual.contains("\r"));
        }
        Assert.assertEquals((String)msg, (Object)expected, (Object)actual);
    }

    static void assertEqualsAndNoLineBreaks(String expected, String actual) {
        ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks(null, expected, actual);
    }
}

