/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.testtools.FileBasedTestCase;

public class RegexFileFilterTestCase
extends FileBasedTestCase {
    public RegexFileFilterTestCase(String name) {
        super(name);
    }

    public void setUp() {
        RegexFileFilterTestCase.getTestDirectory().mkdirs();
    }

    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)RegexFileFilterTestCase.getTestDirectory());
    }

    public void assertFiltering(IOFileFilter filter, File file, boolean expected) throws Exception {
        RegexFileFilterTestCase.assertEquals((String)("Filter(File) " + filter.getClass().getName() + " not " + expected + " for " + file), (boolean)expected, (boolean)filter.accept(file));
        if (file != null && file.getParentFile() != null) {
            RegexFileFilterTestCase.assertEquals((String)("Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for " + file), (boolean)expected, (boolean)filter.accept(file.getParentFile(), file.getName()));
        } else if (file == null) {
            RegexFileFilterTestCase.assertEquals((String)("Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for null"), (boolean)expected, (boolean)filter.accept(file));
        }
    }

    public void testRegex() throws Exception {
        RegexFileFilter filter = new RegexFileFilter("^.*[tT]est(-\\d+)?\\.java$");
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test-10.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test-.java"), false);
        filter = new RegexFileFilter("^[Tt]est.java$");
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java"), false);
        filter = new RegexFileFilter(Pattern.compile("^test.java$", 2));
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java"), true);
        filter = new RegexFileFilter("^test.java$", 2);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java"), true);
        filter = new RegexFileFilter("^test.java$", IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java"), true);
        try {
            new RegexFileFilter((String)null);
            RegexFileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new RegexFileFilter((String)null, 2);
            RegexFileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new RegexFileFilter((String)null, IOCase.INSENSITIVE);
            RegexFileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new RegexFileFilter((Pattern)null);
            RegexFileFilterTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

