/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.io.HexDump;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class HexDumpTest
extends TestCase {
    public HexDumpTest(String name) {
        super(name);
    }

    private char toHex(int n) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        return hexChars[n % 16];
    }

    public void testDump() throws IOException {
        int k;
        int offset;
        int j;
        byte[] testArray = new byte[256];
        for (int j2 = 0; j2 < 256; ++j2) {
            testArray[j2] = (byte)j2;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        HexDump.dump((byte[])testArray, (long)0L, (OutputStream)stream, (int)0);
        byte[] outputArray = new byte[16 * (73 + HexDump.EOL.length())];
        for (int j3 = 0; j3 < 16; ++j3) {
            int k2;
            int offset2 = (73 + HexDump.EOL.length()) * j3;
            outputArray[offset2++] = 48;
            outputArray[offset2++] = 48;
            outputArray[offset2++] = 48;
            outputArray[offset2++] = 48;
            outputArray[offset2++] = 48;
            outputArray[offset2++] = 48;
            outputArray[offset2++] = (byte)this.toHex(j3);
            outputArray[offset2++] = 48;
            outputArray[offset2++] = 32;
            for (k2 = 0; k2 < 16; ++k2) {
                outputArray[offset2++] = (byte)this.toHex(j3);
                outputArray[offset2++] = (byte)this.toHex(k2);
                outputArray[offset2++] = 32;
            }
            for (k2 = 0; k2 < 16; ++k2) {
                outputArray[offset2++] = (byte)this.toAscii(j3 * 16 + k2);
            }
            System.arraycopy(HexDump.EOL.getBytes(), 0, outputArray, offset2, HexDump.EOL.getBytes().length);
        }
        byte[] actualOutput = stream.toByteArray();
        HexDumpTest.assertEquals((String)"array size mismatch", (int)outputArray.length, (int)actualOutput.length);
        for (j = 0; j < outputArray.length; ++j) {
            HexDumpTest.assertEquals((String)("array[ " + j + "] mismatch"), (byte)outputArray[j], (byte)actualOutput[j]);
        }
        stream = new ByteArrayOutputStream();
        HexDump.dump((byte[])testArray, (long)0x10000000L, (OutputStream)stream, (int)0);
        outputArray = new byte[16 * (73 + HexDump.EOL.length())];
        for (j = 0; j < 16; ++j) {
            offset = (73 + HexDump.EOL.length()) * j;
            outputArray[offset++] = 49;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = (byte)this.toHex(j);
            outputArray[offset++] = 48;
            outputArray[offset++] = 32;
            for (k = 0; k < 16; ++k) {
                outputArray[offset++] = (byte)this.toHex(j);
                outputArray[offset++] = (byte)this.toHex(k);
                outputArray[offset++] = 32;
            }
            for (k = 0; k < 16; ++k) {
                outputArray[offset++] = (byte)this.toAscii(j * 16 + k);
            }
            System.arraycopy(HexDump.EOL.getBytes(), 0, outputArray, offset, HexDump.EOL.getBytes().length);
        }
        actualOutput = stream.toByteArray();
        HexDumpTest.assertEquals((String)"array size mismatch", (int)outputArray.length, (int)actualOutput.length);
        for (j = 0; j < outputArray.length; ++j) {
            HexDumpTest.assertEquals((String)("array[ " + j + "] mismatch"), (byte)outputArray[j], (byte)actualOutput[j]);
        }
        stream = new ByteArrayOutputStream();
        HexDump.dump((byte[])testArray, (long)-16777216L, (OutputStream)stream, (int)0);
        outputArray = new byte[16 * (73 + HexDump.EOL.length())];
        for (j = 0; j < 16; ++j) {
            offset = (73 + HexDump.EOL.length()) * j;
            outputArray[offset++] = 70;
            outputArray[offset++] = 70;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = (byte)this.toHex(j);
            outputArray[offset++] = 48;
            outputArray[offset++] = 32;
            for (k = 0; k < 16; ++k) {
                outputArray[offset++] = (byte)this.toHex(j);
                outputArray[offset++] = (byte)this.toHex(k);
                outputArray[offset++] = 32;
            }
            for (k = 0; k < 16; ++k) {
                outputArray[offset++] = (byte)this.toAscii(j * 16 + k);
            }
            System.arraycopy(HexDump.EOL.getBytes(), 0, outputArray, offset, HexDump.EOL.getBytes().length);
        }
        actualOutput = stream.toByteArray();
        HexDumpTest.assertEquals((String)"array size mismatch", (int)outputArray.length, (int)actualOutput.length);
        for (j = 0; j < outputArray.length; ++j) {
            HexDumpTest.assertEquals((String)("array[ " + j + "] mismatch"), (byte)outputArray[j], (byte)actualOutput[j]);
        }
        stream = new ByteArrayOutputStream();
        HexDump.dump((byte[])testArray, (long)0x10000000L, (OutputStream)stream, (int)129);
        outputArray = new byte[8 * (73 + HexDump.EOL.length()) - 1];
        for (j = 0; j < 8; ++j) {
            int index;
            offset = (73 + HexDump.EOL.length()) * j;
            outputArray[offset++] = 49;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = (byte)this.toHex(j + 8);
            outputArray[offset++] = 49;
            outputArray[offset++] = 32;
            for (k = 0; k < 16; ++k) {
                index = 129 + j * 16 + k;
                if (index < 256) {
                    outputArray[offset++] = (byte)this.toHex(index / 16);
                    outputArray[offset++] = (byte)this.toHex(index);
                } else {
                    outputArray[offset++] = 32;
                    outputArray[offset++] = 32;
                }
                outputArray[offset++] = 32;
            }
            for (k = 0; k < 16; ++k) {
                index = 129 + j * 16 + k;
                if (index >= 256) continue;
                outputArray[offset++] = (byte)this.toAscii(index);
            }
            System.arraycopy(HexDump.EOL.getBytes(), 0, outputArray, offset, HexDump.EOL.getBytes().length);
        }
        actualOutput = stream.toByteArray();
        HexDumpTest.assertEquals((String)"array size mismatch", (int)outputArray.length, (int)actualOutput.length);
        for (j = 0; j < outputArray.length; ++j) {
            HexDumpTest.assertEquals((String)("array[ " + j + "] mismatch"), (byte)outputArray[j], (byte)actualOutput[j]);
        }
        try {
            HexDump.dump((byte[])testArray, (long)0x10000000L, (OutputStream)new ByteArrayOutputStream(), (int)-1);
            HexDumpTest.fail((String)"should have caught ArrayIndexOutOfBoundsException on negative index");
        }
        catch (ArrayIndexOutOfBoundsException ignored_exception) {
            // empty catch block
        }
        try {
            HexDump.dump((byte[])testArray, (long)0x10000000L, (OutputStream)new ByteArrayOutputStream(), (int)testArray.length);
            HexDumpTest.fail((String)"should have caught ArrayIndexOutOfBoundsException on large index");
        }
        catch (ArrayIndexOutOfBoundsException ignored_exception) {
            // empty catch block
        }
        try {
            HexDump.dump((byte[])testArray, (long)0x10000000L, null, (int)0);
            HexDumpTest.fail((String)"should have caught IllegalArgumentException on negative index");
        }
        catch (IllegalArgumentException ignored_exception) {
            // empty catch block
        }
    }

    private char toAscii(int c) {
        char rval = '.';
        if (c >= 32 && c <= 126) {
            rval = (char)c;
        }
        return rval;
    }
}

